/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
********************************************************************************
* FileName: CommandPackage.h                                                   *
*                                                                              *
* Author                     Date           Version                            *
*------------------------------------------------------------------------------*
* Carlos Grossy              21/03/2007       1.0                              *
*******************************************************************************/

#ifndef _COMMANDPACKAGE_H_
#define _COMMANDPACKAGE_H_

#include "USBTrans.h"
#include "U4ATypes.h"

typedef struct commPackage {
    command tc;
    union {
        struct { // OPEN ==>
            int usbin;
            int usbout;
            char *disp;
        };
        struct { // OPEN <==
            handler h;
        };
        struct { // CLOSE ==>
            handler hnd;
        };
        struct { // CLOSE <==
            int res;
        };
    };
};
//commPackage::~commPackage () { delete [] disp; }

typedef struct commPackageResponse {
    char tc;
    union {
        struct { // OPEN
            unsigned char h;
        };
        struct { // CLOSE
            unsigned char res;
        };
        struct { // MESSAGE
            unsigned char msg[252];
        };
    };
};

class commandPackage {
    public:
        commandPackage();
        ~commandPackage();
        char * buildPackage(commPackage*, int&);
        commPackage* unbuildPackage(char*, int);
};

#endif
